/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.connection;

import com.esotericsoftware.kryonet.rmi.TimeoutException;
import info.novatec.inspectit.agent.connection.RetryException;
import info.novatec.inspectit.agent.connection.RetryStrategy;
import info.novatec.inspectit.agent.connection.ServerUnavailableException;
import info.novatec.inspectit.agent.connection.impl.AdditiveWaitRetryStrategy;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteMethodCall<R, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteMethodCall.class);
    private R remoteObject;

    public AbstractRemoteMethodCall(R remoteObject) {
        if (null == remoteObject) {
            throw new IllegalArgumentException("Remote object can not be null");
        }
        this.remoteObject = remoteObject;
    }

    public final T makeCall() throws ServerUnavailableException, ExecutionException {
        RetryStrategy strategy = this.getRetryStrategy();
        while (strategy.shouldRetry()) {
            R remoteObject = this.getRemoteObject();
            if (null == remoteObject) {
                throw new ServerUnavailableException();
            }
            try {
                return this.performRemoteCall(remoteObject);
            }
            catch (TimeoutException timeoutException) {
                throw new ServerUnavailableException(true);
            }
            catch (RuntimeException remoteException) {
                try {
                    strategy.remoteExceptionOccured();
                }
                catch (RetryException retryException) {
                    this.handleRetryException(remoteObject);
                }
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        return null;
    }

    protected R getRemoteObject() throws ServerUnavailableException {
        return this.remoteObject;
    }

    protected abstract T performRemoteCall(R var1) throws Exception;

    protected RetryStrategy getRetryStrategy() {
        return new AdditiveWaitRetryStrategy();
    }

    protected final void handleRetryException(R remoteObject) throws ServerUnavailableException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Repeated attempts to communicate with " + remoteObject + " failed.");
        }
        throw new ServerUnavailableException();
    }
}

