/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.config.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.analyzer.impl.AnnotationMatcher;
import info.novatec.inspectit.agent.analyzer.impl.DirectMatcher;
import info.novatec.inspectit.agent.analyzer.impl.IndirectMatcher;
import info.novatec.inspectit.agent.analyzer.impl.InterfaceMatcher;
import info.novatec.inspectit.agent.analyzer.impl.ModifierMatcher;
import info.novatec.inspectit.agent.analyzer.impl.SimpleMatchPattern;
import info.novatec.inspectit.agent.analyzer.impl.SuperclassMatcher;
import info.novatec.inspectit.agent.analyzer.impl.ThrowableMatcher;
import info.novatec.inspectit.agent.config.impl.AbstractSensorConfig;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnregisteredSensorConfig
extends AbstractSensorConfig {
    private final IClassPoolAnalyzer classPoolAnalyzer;
    private final IInheritanceAnalyzer inheritanceAnalyzer;
    private boolean superclass = false;
    private boolean interf = false;
    private boolean virtual = false;
    private boolean ignoreSignature = false;
    private boolean exceptionSensorActivated = false;
    private int modifiers = 0;
    private IMatcher matcher;
    private MethodSensorTypeConfig sensorTypeConfig;
    private String annotationClassName;

    public UnregisteredSensorConfig(IClassPoolAnalyzer classPoolAnalyzer, IInheritanceAnalyzer inheritanceAnalyzer) {
        this.classPoolAnalyzer = classPoolAnalyzer;
        this.inheritanceAnalyzer = inheritanceAnalyzer;
    }

    @Override
    public void setTargetClassName(String targetClassName) {
        super.setTargetClassName(targetClassName);
        if (SimpleMatchPattern.isPattern(targetClassName)) {
            this.setVirtual(true);
        }
    }

    @Override
    public void setTargetMethodName(String targetMethodName) {
        super.setTargetMethodName(targetMethodName);
        if (SimpleMatchPattern.isPattern(targetMethodName)) {
            this.setVirtual(true);
        }
    }

    @Override
    public void setParameterTypes(List<String> parameterTypes) {
        if (null != parameterTypes) {
            super.setParameterTypes(parameterTypes);
            for (String parameter : parameterTypes) {
                if (!SimpleMatchPattern.isPattern(parameter)) continue;
                this.setVirtual(true);
            }
        }
    }

    public boolean isSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(boolean superclass) {
        this.superclass = superclass;
    }

    public boolean isInterface() {
        return this.interf;
    }

    public void setInterface(boolean interf) {
        this.interf = interf;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isIgnoreSignature() {
        return this.ignoreSignature;
    }

    public void setIgnoreSignature(boolean ignoreSignature) {
        this.ignoreSignature = ignoreSignature;
    }

    public MethodSensorTypeConfig getSensorTypeConfig() {
        return this.sensorTypeConfig;
    }

    public void setSensorTypeConfig(MethodSensorTypeConfig sensorTypeConfig) {
        this.sensorTypeConfig = sensorTypeConfig;
    }

    public void setExceptionSensorActivated(boolean exceptionSensorActivated) {
        this.exceptionSensorActivated = exceptionSensorActivated;
    }

    public boolean isExceptionSensorActivated() {
        return this.exceptionSensorActivated;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public IMatcher getMatcher() {
        return this.matcher;
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public void setAnnotationClassName(String annotationClassName) {
        this.annotationClassName = annotationClassName;
    }

    public void completeConfiguration() {
        if (!(this.virtual || this.superclass || this.interf)) {
            this.matcher = new DirectMatcher(this.classPoolAnalyzer, this);
        } else if (this.superclass && !this.interf) {
            this.matcher = new SuperclassMatcher(this.inheritanceAnalyzer, this.classPoolAnalyzer, this);
        } else if (!this.superclass && this.interf) {
            this.matcher = new InterfaceMatcher(this.inheritanceAnalyzer, this.classPoolAnalyzer, this);
        } else if (this.virtual && !this.superclass && !this.interf) {
            this.matcher = new IndirectMatcher(this.classPoolAnalyzer, this);
        }
        if (null != this.annotationClassName) {
            this.matcher = new AnnotationMatcher(this.inheritanceAnalyzer, this.classPoolAnalyzer, this, this.matcher);
        }
        if (this.exceptionSensorActivated) {
            this.matcher = new ThrowableMatcher(this.inheritanceAnalyzer, this.classPoolAnalyzer, this, this.matcher);
        }
        if (this.modifiers != 0) {
            this.matcher = new ModifierMatcher(this.classPoolAnalyzer, this, this.matcher);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " superclass:" + this.superclass + " interface:" + this.interf + " virtual:" + this.virtual;
    }
}

