/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.config.impl;

import info.novatec.inspectit.agent.config.impl.AbstractSensorConfig;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.hooking.IHook;
import info.novatec.inspectit.agent.sensor.method.IMethodSensor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javassist.CtBehavior;
import javassist.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredSensorConfig
extends AbstractSensorConfig {
    private CtBehavior ctBehavior;
    private long id;
    private String returnType = "";
    private List<MethodSensorTypeConfig> sensorTypeConfigs = new ArrayList<MethodSensorTypeConfig>();
    private MethodSensorTypeConfig invocationSequenceSensorTypeConfig = null;
    private MethodSensorTypeConfig exceptionSensorTypeConfig = null;
    private Map<Long, IHook> methodHookMap = new LinkedHashMap<Long, IHook>();
    private Map<Long, IHook> reverseMethodHookMap = new LinkedHashMap<Long, IHook>();
    private int modifiers;
    private Comparator<MethodSensorTypeConfig> sensorTypeConfigComparator = new SensorTypeConfigComparator();

    public void setCtBehavior(CtBehavior behavior) {
        this.ctBehavior = behavior;
    }

    public CtBehavior getCtBehavior() {
        return this.ctBehavior;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public List<MethodSensorTypeConfig> getSensorTypeConfigs() {
        return this.sensorTypeConfigs;
    }

    public void addSensorTypeConfig(MethodSensorTypeConfig sensorTypeConfig) {
        if (sensorTypeConfig.getClassName().endsWith("InvocationSequenceSensor")) {
            this.invocationSequenceSensorTypeConfig = sensorTypeConfig;
        }
        if (sensorTypeConfig.getClassName().endsWith("ExceptionSensor")) {
            this.exceptionSensorTypeConfig = sensorTypeConfig;
        }
        if (!this.sensorTypeConfigs.contains(sensorTypeConfig)) {
            this.sensorTypeConfigs.add(sensorTypeConfig);
            this.sortSensorTypeConfigs();
            this.sortMethodHooks();
        }
    }

    public void removeSensorTypeConfig(MethodSensorTypeConfig sensorTypeConfig) {
        if (this.sensorTypeConfigs.contains(sensorTypeConfig)) {
            this.sensorTypeConfigs.remove(sensorTypeConfig);
            this.sortMethodHooks();
        }
    }

    private void sortSensorTypeConfigs() {
        if (this.sensorTypeConfigs.size() > 1) {
            Collections.sort(this.sensorTypeConfigs, this.sensorTypeConfigComparator);
        }
    }

    public Map<Long, IHook> getMethodHooks() {
        return this.methodHookMap;
    }

    public Map<Long, IHook> getReverseMethodHooks() {
        return this.reverseMethodHookMap;
    }

    private void sortMethodHooks() {
        IMethodSensor methodSensor;
        this.methodHookMap.clear();
        for (MethodSensorTypeConfig sensorTypeConfig : this.sensorTypeConfigs) {
            methodSensor = (IMethodSensor)sensorTypeConfig.getSensorType();
            this.methodHookMap.put(sensorTypeConfig.getId(), methodSensor.getHook());
        }
        this.reverseMethodHookMap.clear();
        ListIterator<MethodSensorTypeConfig> iterator = this.sensorTypeConfigs.listIterator(this.sensorTypeConfigs.size());
        while (iterator.hasPrevious()) {
            MethodSensorTypeConfig sensorTypeConfig;
            sensorTypeConfig = iterator.previous();
            methodSensor = (IMethodSensor)sensorTypeConfig.getSensorType();
            this.reverseMethodHookMap.put(sensorTypeConfig.getId(), methodSensor.getHook());
        }
    }

    public boolean startsInvocationSequence() {
        return null != this.invocationSequenceSensorTypeConfig;
    }

    public MethodSensorTypeConfig getExceptionSensorTypeConfig() {
        return this.exceptionSensorTypeConfig;
    }

    public void setExceptionSensorTypeConfig(MethodSensorTypeConfig exceptionSensorTypeConfig) {
        this.exceptionSensorTypeConfig = exceptionSensorTypeConfig;
        if (!this.sensorTypeConfigs.contains(this.exceptionSensorTypeConfig)) {
            this.sensorTypeConfigs.add(this.exceptionSensorTypeConfig);
            this.sortSensorTypeConfigs();
        }
    }

    public MethodSensorTypeConfig getInvocationSequenceSensorTypeConfig() {
        return this.invocationSequenceSensorTypeConfig;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String toString() {
        return this.id + " :: " + Modifier.toString((int)this.modifiers) + " " + this.getTargetPackageName() + "." + this.getTargetClassName() + "#" + this.getTargetMethodName() + "(" + this.getParameterTypes() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SensorTypeConfigComparator
    implements Comparator<MethodSensorTypeConfig>,
    Serializable {
        private static final long serialVersionUID = -2156911328015024777L;

        private SensorTypeConfigComparator() {
        }

        @Override
        public int compare(MethodSensorTypeConfig sensorTypeConfig1, MethodSensorTypeConfig sensorTypeConfig2) {
            return sensorTypeConfig2.getPriority().compareTo(sensorTypeConfig1.getPriority());
        }
    }
}

