/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.config.impl;

import info.novatec.inspectit.agent.config.IPropertyAccessor;
import info.novatec.inspectit.agent.config.PropertyAccessException;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.ParameterContentType;
import info.novatec.inspectit.spring.logger.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class PropertyAccessor
implements IPropertyAccessor {
    @Log
    Logger log;
    private static final String NULL_VALUE = "null";
    private static final String[] ALLOWED_METHODS = new String[]{"size", "length"};

    @Override
    public String getPropertyContent(PropertyPathStart propertyPathStart, Object clazz, Object[] parameters, Object returnValue) throws PropertyAccessException {
        if (null == propertyPathStart) {
            throw new PropertyAccessException("Property path start cannot be null!");
        }
        if (null == propertyPathStart.contentType) {
            throw new PropertyAccessException("Content type is not defined.");
        }
        switch (propertyPathStart.contentType) {
            case FIELD: {
                if (null == clazz) {
                    throw new PropertyAccessException("Class reference cannot be null!");
                }
                return this.getPropertyContent(propertyPathStart.getPathToContinue(), clazz);
            }
            case PARAM: {
                if (null == parameters) {
                    throw new PropertyAccessException("Parameter array reference cannot be null!");
                }
                if (propertyPathStart.getSignaturePosition() >= parameters.length) {
                    throw new PropertyAccessException("Signature position out of range!");
                }
                return this.getPropertyContent(propertyPathStart.getPathToContinue(), parameters[propertyPathStart.getSignaturePosition()]);
            }
            case RETURN: {
                if (null == returnValue) {
                    return NULL_VALUE;
                }
                return this.getPropertyContent(propertyPathStart.getPathToContinue(), returnValue);
            }
        }
        throw new PropertyAccessException("Missing handler for type " + propertyPathStart.contentType);
    }

    private boolean isAcceptedMethod(String method) {
        for (int i = 0; i < ALLOWED_METHODS.length; ++i) {
            String allowed = ALLOWED_METHODS[i];
            if (!allowed.equals(method)) continue;
            return true;
        }
        return false;
    }

    private String getPropertyContent(PropertyPath propertyPath, Object object) throws PropertyAccessException {
        if (null == object) {
            return NULL_VALUE;
        }
        if (null == propertyPath) {
            return object.toString();
        }
        Class<?> c = object instanceof Class ? (Class<?>)object : object.getClass();
        if (propertyPath.isMethodCall()) {
            String methodName = propertyPath.getName().substring(0, propertyPath.getName().length() - 2);
            if (!this.isAcceptedMethod(methodName)) {
                throw new PropertyAccessException("Method " + methodName + " MAY not be called!");
            }
            if ("length".equals(methodName)) {
                if (object.getClass().isArray()) {
                    return this.getPropertyContent(propertyPath.getPathToContinue(), Array.getLength(object));
                }
                this.log.error("Trying to access the lenght() method for a non array type");
                throw new PropertyAccessException("Trying to access the length() method for a non array type");
            }
            do {
                Method[] methods = c.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!methodName.equals(method.getName())) continue;
                    if (method.getParameterTypes().length != 0) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping matching method " + method.getName() + " as it is not a no argument method");
                        continue;
                    }
                    try {
                        Object result = method.invoke(object, (Object[])null);
                        return this.getPropertyContent(propertyPath.getPathToContinue(), result);
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error(e.getMessage());
                        throw new PropertyAccessException("Illegal Argument Exception!", e);
                    }
                    catch (IllegalAccessException e) {
                        this.log.error(e.getMessage());
                        throw new PropertyAccessException("IllegalAccessException!", e);
                    }
                    catch (InvocationTargetException e) {
                        this.log.error(e.getMessage());
                        throw new PropertyAccessException("InvocationTargetException!", e);
                    }
                }
            } while ((c = c.getSuperclass()) != Object.class);
        } else {
            do {
                Field[] fields = c.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (!propertyPath.getName().equals(field.getName())) continue;
                    try {
                        field.setAccessible(true);
                        Object fieldObject = field.get(object);
                        return this.getPropertyContent(propertyPath.getPathToContinue(), fieldObject);
                    }
                    catch (SecurityException e) {
                        this.log.error(e.getMessage());
                        throw new PropertyAccessException("Security Exception was thrown while accessing a field!", e);
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error(e.getMessage());
                        throw new PropertyAccessException("Illegal Argument Exception!", e);
                    }
                    catch (IllegalAccessException e) {
                        this.log.error(e.getMessage());
                        throw new PropertyAccessException("Illegal Access Exception!", e);
                    }
                }
            } while ((c = c.getSuperclass()) != Object.class);
        }
        throw new PropertyAccessException("Property or method " + propertyPath.getName() + " cannot be found in class " + object.getClass() + "!");
    }

    @Override
    public List<ParameterContentData> getParameterContentData(List<PropertyPathStart> propertyAccessorList, Object clazz, Object[] parameters, Object returnValue) {
        ArrayList<ParameterContentData> parameterContentData = new ArrayList<ParameterContentData>();
        for (PropertyPathStart start : propertyAccessorList) {
            try {
                String content = this.getPropertyContent(start, clazz, parameters, returnValue);
                ParameterContentData paramContentData = new ParameterContentData();
                paramContentData.setContent(content);
                paramContentData.setContentType(start.getContentType());
                paramContentData.setName(start.getName());
                paramContentData.setSignaturePosition(start.getSignaturePosition());
                parameterContentData.add(paramContentData);
            }
            catch (PropertyAccessException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("Cannot access the property: " + start + " for class " + clazz + ". Will be removed from the list to prevent further errors! (" + e.getMessage() + ")");
                }
                propertyAccessorList.remove(start);
            }
        }
        return parameterContentData;
    }

    public static class PropertyPathStart
    extends PropertyPath {
        private ParameterContentType contentType;
        private int signaturePosition = -1;

        public ParameterContentType getContentType() {
            return this.contentType;
        }

        public void setContentType(ParameterContentType contentType) {
            this.contentType = contentType;
        }

        public void setSignaturePosition(int signaturePosition) {
            this.signaturePosition = signaturePosition;
        }

        public int getSignaturePosition() {
            return this.signaturePosition;
        }

        public String toString() {
            if (null != this.getPathToContinue()) {
                return "[" + this.getName() + "] " + this.getPathToContinue().toString();
            }
            return "[" + this.getName() + "]";
        }
    }

    public static class PropertyPath {
        private String name;
        private PropertyPath pathToContinue;

        public PropertyPath() {
        }

        public PropertyPath(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setPathToContinue(PropertyPath pathToContinue) {
            this.pathToContinue = pathToContinue;
        }

        public PropertyPath getPathToContinue() {
            return this.pathToContinue;
        }

        public boolean isMethodCall() {
            return this.name.endsWith("()");
        }

        public String toString() {
            if (null != this.pathToContinue) {
                return this.name + "-->" + this.pathToContinue.toString();
            }
            return this.name;
        }
    }
}

