/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.config.impl;

import info.novatec.inspectit.agent.analyzer.IMatchPattern;
import info.novatec.inspectit.agent.config.IConfigurationReader;
import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.ParserException;
import info.novatec.inspectit.agent.config.PriorityEnum;
import info.novatec.inspectit.agent.config.StorageException;
import info.novatec.inspectit.agent.logback.LogInitializer;
import info.novatec.inspectit.spring.logger.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="configurationReader")
public class FileConfigurationReader
implements IConfigurationReader,
InitializingBean {
    @Log
    Logger log;
    private static final String[] DEFAULT_IGNORE_PATTERNS = new String[]{"java.security.SecureClassLoader", "info.novatec.inspectit.*", "$Proxy*", "sun.*", "java.lang.ThreadLocal", "java.lang.ref.Reference", "*_WLStub", "*[]"};
    private final IConfigurationStorage configurationStorage;
    private static final String CONFIGURATION_PROPERTY = "inspectit.config";
    private static final String CONFIGURATION_FILE = "inspectit-agent.cfg";
    private static final String CONFIG_COMMENT = "#";
    private static final String CONFIG_REPOSITORY = "repository";
    private static final String CONFIG_SEND_STRATEGY = "send-strategy";
    private static final String CONFIG_BUFFER_STRATEGY = "buffer-strategy";
    private static final String CONFIG_METHOD_SENSOR_TYPE = "method-sensor-type";
    private static final String CONFIG_PLATFORM_SENSOR_TYPE = "platform-sensor-type";
    private static final String CONFIG_SENSOR = "sensor";
    private static final String CONFIG_EXCEPTION_SENSOR = "exception-sensor";
    private static final String CONFIG_EXCEPTION_SENSOR_TYPE = "exception-sensor-type";
    private static final String CONFIG_JMX_SENSOR = "jmx-sensor";
    private static final String CONFIG_JMX_SENSOR_TYPE = "jmx-sensor-type";
    private static final String CONFIG_INCLUDE_FILE = "$include";
    private static final String CONFIG_EXCLUDE_CLASS = "exclude-class";
    private static final String MBEAN_NAME_IDENTIFIER = "mbeanname=";
    private static final String MBEAN_ATTRIBUTENAME_IDENTIFIER = "attributename=";
    private final Pattern methodSignature = Pattern.compile(".*\\((.+)\\)");
    private final Pattern emptyMethodSignature = Pattern.compile(".*\\(\\)");

    @Autowired
    public FileConfigurationReader(IConfigurationStorage configurationStorage) {
        this.configurationStorage = configurationStorage;
    }

    public void load() throws ParserException {
        String pathToConfig = System.getProperty(CONFIGURATION_PROPERTY) + File.separator + CONFIGURATION_FILE;
        if ("".equals(pathToConfig)) {
            pathToConfig = System.getProperty("user.dir") + File.separator + "inspectit" + File.separator + CONFIGURATION_PROPERTY;
        }
        try {
            File configFile = new File(pathToConfig);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Agent Configuration file found at: " + configFile.getAbsolutePath());
            }
            FileInputStream is = new FileInputStream(configFile);
            InputStreamReader reader = new InputStreamReader(is);
            this.parse(reader, pathToConfig);
            List<IMatchPattern> ignorePatterns = this.configurationStorage.getIgnoreClassesPatterns();
            if (null == ignorePatterns || ignorePatterns.isEmpty()) {
                for (String ignorePatternString : DEFAULT_IGNORE_PATTERNS) {
                    this.configurationStorage.addIgnoreClassesPattern(ignorePatternString);
                }
            }
        }
        catch (FileNotFoundException e) {
            this.log.info("Agent Configuration file not found at " + pathToConfig + ", aborting!");
            throw new ParserException("Agent Configuration file not found at " + pathToConfig, e);
        }
    }

    void parse(Reader reader, String pathToConfig) throws ParserException {
        if (null == reader) {
            throw new ParserException("Input is null! Aborting parsing.");
        }
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("") || line.startsWith(CONFIG_COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                String discriminator = tokenizer.nextToken();
                if (discriminator.equalsIgnoreCase(CONFIG_REPOSITORY)) {
                    this.processRepositoryLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_SEND_STRATEGY)) {
                    this.processSendStrategyLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_BUFFER_STRATEGY)) {
                    this.processBufferStrategyLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_METHOD_SENSOR_TYPE)) {
                    this.processMethodSensorTypeLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_PLATFORM_SENSOR_TYPE)) {
                    this.processPlatformSensorTypeLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_EXCEPTION_SENSOR_TYPE)) {
                    this.processExceptionSensorTypeLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_EXCEPTION_SENSOR)) {
                    this.processExceptionSensorLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_JMX_SENSOR_TYPE)) {
                    this.processJmxSensorTypeLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_JMX_SENSOR)) {
                    this.processJmxSensorLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_SENSOR)) {
                    this.processSensorLine(tokenizer);
                    continue;
                }
                if (discriminator.equalsIgnoreCase(CONFIG_INCLUDE_FILE)) {
                    this.processIncludeFileLine(tokenizer, pathToConfig);
                    continue;
                }
                if (!discriminator.equalsIgnoreCase(CONFIG_EXCLUDE_CLASS)) continue;
                this.processExcludeClassLine(tokenizer);
            }
        }
        catch (Throwable throwable) {
            this.log.error("Error reading config on line : " + line);
            throw new ParserException("Error reading config on line : " + line, throwable);
        }
    }

    private void processJmxSensorTypeLine(StringTokenizer tokenizer) throws ParserException {
        String sensorName = tokenizer.nextToken();
        String sensorTypeClass = tokenizer.nextToken();
        try {
            this.configurationStorage.addJmxSensorType(sensorTypeClass, sensorName);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the jmx sensor type to the storage", e);
        }
    }

    private void processJmxSensorLine(StringTokenizer tokenizer) throws ParserException {
        String jmxSensorTypeName = tokenizer.nextToken();
        String mBeanName = "";
        String attributeName = "";
        boolean marker = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.contains(MBEAN_NAME_IDENTIFIER)) {
                mBeanName = token.substring(MBEAN_NAME_IDENTIFIER.length());
                continue;
            }
            if (token.contains(MBEAN_ATTRIBUTENAME_IDENTIFIER)) {
                marker = false;
                attributeName = token.substring(MBEAN_ATTRIBUTENAME_IDENTIFIER.length());
                continue;
            }
            if (marker) {
                mBeanName = mBeanName + " " + token;
                continue;
            }
            attributeName = attributeName + " " + token;
        }
        try {
            this.configurationStorage.addUnregisteredJmxConfig(jmxSensorTypeName, mBeanName, attributeName);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the jmx sensor type to the storage", e);
        }
    }

    private void processExceptionSensorTypeLine(StringTokenizer tokenizer) throws ParserException {
        String sensorTypeClass = tokenizer.nextToken();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (tokenizer.hasMoreTokens()) {
            String parameterToken = tokenizer.nextToken();
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            settings.put(leftSide, rightSide);
        }
        Object mode = settings.get("mode");
        if (null != mode && "enhanced".equals(mode)) {
            this.configurationStorage.setEnhancedExceptionSensorActivated(true);
        } else {
            this.configurationStorage.setEnhancedExceptionSensorActivated(false);
        }
        try {
            this.configurationStorage.addExceptionSensorType(sensorTypeClass, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the exception sensor type to the storage", e);
        }
    }

    private void processExceptionSensorLine(StringTokenizer tokenizer) throws ParserException {
        String sensorTypeClass = "info.novatec.inspectit.agent.sensor.exception.ExceptionSensor";
        String targetClassName = tokenizer.nextToken();
        boolean isVirtual = false;
        if (targetClassName.indexOf(42) > -1) {
            isVirtual = true;
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (tokenizer.hasMoreTokens()) {
            String parameterToken = tokenizer.nextToken();
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            settings.put(leftSide, rightSide);
        }
        try {
            this.configurationStorage.addExceptionSensorTypeParameter(sensorTypeClass, targetClassName, isVirtual, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the exception sensor type parameter to the storage", e);
        }
    }

    private void processMethodSensorTypeLine(StringTokenizer tokenizer) throws ParserException {
        String sensorTypeName = tokenizer.nextToken();
        String sensorTypeClass = tokenizer.nextToken();
        String priorityString = tokenizer.nextToken();
        PriorityEnum priority = PriorityEnum.valueOf(priorityString);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (tokenizer.hasMoreTokens()) {
            String parameterToken = tokenizer.nextToken();
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            settings.put(leftSide, rightSide);
        }
        try {
            this.configurationStorage.addMethodSensorType(sensorTypeName, sensorTypeClass, priority, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the method sensor type to the storage", e);
        }
    }

    private void processPlatformSensorTypeLine(StringTokenizer tokenizer) throws ParserException {
        String sensorTypeClass = tokenizer.nextToken();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (tokenizer.hasMoreTokens()) {
            String parameterToken = tokenizer.nextToken();
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            settings.put(leftSide, rightSide);
        }
        try {
            this.configurationStorage.addPlatformSensorType(sensorTypeClass, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the platform sensor type to the storage", e);
        }
    }

    private void processSensorLine(StringTokenizer tokenizer) throws ParserException {
        String sensorTypeName = tokenizer.nextToken();
        String targetClassName = tokenizer.nextToken();
        String targetMethodName = tokenizer.nextToken();
        boolean ignoreSignature = false;
        Matcher m = this.methodSignature.matcher(targetMethodName);
        List<String> parameterList = Collections.emptyList();
        if (m.matches()) {
            String[] classes = m.group(1).split(",");
            parameterList = new ArrayList(classes.length);
            for (String clazz : classes) {
                parameterList.add(clazz.trim());
            }
            targetMethodName = targetMethodName.split("\\(")[0];
        } else if (this.emptyMethodSignature.matcher(targetMethodName).matches()) {
            targetMethodName = targetMethodName.replaceAll("\\(\\)", "");
        } else {
            ignoreSignature = true;
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (tokenizer.hasMoreTokens()) {
            List<String> propertyAccessorList;
            String parameterToken = tokenizer.nextToken();
            if (parameterToken.charAt(0) == '@') {
                settings.put("annotation", parameterToken.substring(1));
                continue;
            }
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            if ("property".equals(leftSide) || "p".equals(leftSide)) {
                propertyAccessorList = (ArrayList<String>)settings.get("property");
                if (null == propertyAccessorList) {
                    propertyAccessorList = new ArrayList<String>();
                    settings.put("property", propertyAccessorList);
                }
                propertyAccessorList.add(rightSide);
                continue;
            }
            if ("field".equals(leftSide) || "f".equals(leftSide)) {
                propertyAccessorList = (List)settings.get("field");
                if (null == propertyAccessorList) {
                    propertyAccessorList = new ArrayList();
                    settings.put("field", propertyAccessorList);
                }
                propertyAccessorList.add(rightSide);
                continue;
            }
            if ("return".equals(leftSide) || "r".equals(leftSide)) {
                propertyAccessorList = (List)settings.get("return");
                if (null == propertyAccessorList) {
                    propertyAccessorList = new ArrayList();
                    settings.put("return", propertyAccessorList);
                }
                propertyAccessorList.add(rightSide);
                continue;
            }
            settings.put(leftSide, rightSide);
        }
        try {
            this.configurationStorage.addSensor(sensorTypeName, targetClassName, targetMethodName, parameterList, ignoreSignature, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the sensor to the storage", e);
        }
    }

    private void processRepositoryLine(StringTokenizer tokenizer) throws ParserException {
        String host = tokenizer.nextToken();
        int port = Integer.parseInt(tokenizer.nextToken());
        String name = tokenizer.nextToken();
        LogInitializer.setAgentNameAndInitLogging(name);
        try {
            this.configurationStorage.setAgentName(name);
            this.configurationStorage.setRepository(host, port);
        }
        catch (StorageException e) {
            throw new ParserException("Could net set the agent name or repository", e);
        }
    }

    private void processSendStrategyLine(StringTokenizer tokenizer) throws ParserException {
        String sendStrategyClass = tokenizer.nextToken();
        HashMap<String, String> settings = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String parameterToken = tokenizer.nextToken();
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            settings.put(leftSide, rightSide);
        }
        try {
            this.configurationStorage.addSendingStrategy(sendStrategyClass, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not add the sending strategy to the storage", e);
        }
    }

    private void processBufferStrategyLine(StringTokenizer tokenizer) throws ParserException {
        String bufferStrategyClass = tokenizer.nextToken();
        HashMap<String, String> settings = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String parameterToken = tokenizer.nextToken();
            StringTokenizer parameterTokenizer = new StringTokenizer(parameterToken, "=");
            String leftSide = parameterTokenizer.nextToken();
            String rightSide = parameterTokenizer.nextToken();
            settings.put(leftSide, rightSide);
        }
        try {
            this.configurationStorage.setBufferStrategy(bufferStrategyClass, settings);
        }
        catch (StorageException e) {
            throw new ParserException("Could not set the buffer strategy in the storage", e);
        }
    }

    private void processIncludeFileLine(StringTokenizer tokenizer, String pathToParentFile) throws ParserException {
        String fileName = tokenizer.nextToken();
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(new File(pathToParentFile).getParent() + File.separator + fileName);
        }
        if (file.isDirectory()) {
            this.log.info("Specified additional configuration is a folder: " + file.getAbsolutePath() + ", aborting!");
            throw new ParserException("Specified additional configuration is a folder: " + file.getAbsolutePath());
        }
        try {
            this.log.info("Additional agent configuration file found at: " + file.getAbsolutePath());
            FileInputStream is = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(is);
            this.parse(reader, file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            this.log.info("Additional agent configuration file not found at " + file.getAbsolutePath() + ", aborting!");
            throw new ParserException("Additional agent Configuration file not found at " + file.getAbsolutePath(), e);
        }
    }

    private void processExcludeClassLine(StringTokenizer tokenizer) {
        while (tokenizer.hasMoreTokens()) {
            String patternString = tokenizer.nextToken();
            this.configurationStorage.addIgnoreClassesPattern(patternString);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.load();
    }
}

