/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.config.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatchPattern;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.analyzer.impl.DirectMatcher;
import info.novatec.inspectit.agent.analyzer.impl.SimpleMatchPattern;
import info.novatec.inspectit.agent.analyzer.impl.SuperclassMatcher;
import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.PriorityEnum;
import info.novatec.inspectit.agent.config.StorageException;
import info.novatec.inspectit.agent.config.impl.JmxSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PlatformSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PropertyAccessor;
import info.novatec.inspectit.agent.config.impl.RepositoryConfig;
import info.novatec.inspectit.agent.config.impl.StrategyConfig;
import info.novatec.inspectit.agent.config.impl.UnregisteredJmxConfig;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import info.novatec.inspectit.agent.jrebel.JRebelUtil;
import info.novatec.inspectit.communication.data.ParameterContentType;
import info.novatec.inspectit.spring.logger.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ConfigurationStorage
implements IConfigurationStorage,
InitializingBean {
    @Log
    Logger log;
    private static final String REPOSITORY_PROPERTY = "inspectit.repository";
    private final IClassPoolAnalyzer classPoolAnalyzer;
    private final IInheritanceAnalyzer inheritanceAnalyzer;
    private RepositoryConfig repository;
    private String agentName;
    private StrategyConfig bufferStrategy;
    private List<StrategyConfig> sendingStrategies = new ArrayList<StrategyConfig>(1);
    private static final int METHOD_LIST_SIZE = 10;
    private List<MethodSensorTypeConfig> methodSensorTypes = new ArrayList<MethodSensorTypeConfig>(10);
    private static final int PLATFORM_LIST_SIZE = 10;
    private List<PlatformSensorTypeConfig> platformSensorTypes = new ArrayList<PlatformSensorTypeConfig>(10);
    private static final int JMX_LIST_SIZE = 1;
    private List<JmxSensorTypeConfig> jmxSensorTypes = new ArrayList<JmxSensorTypeConfig>(1);
    private List<UnregisteredSensorConfig> unregisteredSensorConfigs = new ArrayList<UnregisteredSensorConfig>();
    private List<UnregisteredJmxConfig> unregisteredJmxConfigs = new ArrayList<UnregisteredJmxConfig>();
    private boolean exceptionSensorActivated = false;
    private boolean enhancedExceptionSensorActivated = false;
    private List<IMatchPattern> ignoreClassesPatterns = new ArrayList<IMatchPattern>();
    private Collection<IMatcher> classLoaderDelegationMatchers;

    @Autowired
    public ConfigurationStorage(IClassPoolAnalyzer classPoolAnalyzer, IInheritanceAnalyzer inheritanceAnalyzer) {
        this.classPoolAnalyzer = classPoolAnalyzer;
        this.inheritanceAnalyzer = inheritanceAnalyzer;
    }

    @Override
    public final void setRepository(String host, int port) throws StorageException {
        if (null == host || "".equals(host)) {
            throw new StorageException("Repository host name cannot be null or empty!");
        }
        if (port < 1) {
            throw new StorageException("Repository port has to be greater than 0!");
        }
        if (null == this.repository) {
            this.repository = new RepositoryConfig(host, port);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Repository definition added. Host: " + host + " Port: " + port);
        }
    }

    @Override
    public RepositoryConfig getRepositoryConfig() {
        return this.repository;
    }

    @Override
    public final void setAgentName(String name) throws StorageException {
        if (null == name || "".equals(name)) {
            throw new StorageException("Agent name cannot be null or empty!");
        }
        if (null == this.agentName) {
            this.agentName = name;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Agent name set to: " + name);
        }
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public void setBufferStrategy(String clazzName, Map<String, String> settings) throws StorageException {
        if (null == clazzName || "".equals(clazzName)) {
            throw new StorageException("Buffer strategy class name cannot be null or empty!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        this.bufferStrategy = new StrategyConfig(clazzName, settings);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Buffer strategy set to: " + clazzName);
        }
    }

    @Override
    public StrategyConfig getBufferStrategyConfig() {
        return this.bufferStrategy;
    }

    @Override
    public void addSendingStrategy(String clazzName, Map<String, String> settings) throws StorageException {
        if (null == clazzName || "".equals(clazzName)) {
            throw new StorageException("Sending strategy class name cannot be null or empty!");
        }
        for (StrategyConfig config : this.sendingStrategies) {
            if (!clazzName.equals(config.getClazzName())) continue;
            throw new StorageException("Sending strategy class is already registered!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        this.sendingStrategies.add(new StrategyConfig(clazzName, settings));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending strategy added: " + clazzName);
        }
    }

    @Override
    public List<StrategyConfig> getSendingStrategyConfigs() {
        return Collections.unmodifiableList(this.sendingStrategies);
    }

    @Override
    public void addMethodSensorType(String sensorTypeName, String sensorTypeClass, PriorityEnum priority, Map<String, Object> settings) throws StorageException {
        if (null == sensorTypeName || "".equals(sensorTypeName)) {
            throw new StorageException("Method sensor type name cannot be null or empty!");
        }
        if (null == sensorTypeClass || "".equals(sensorTypeClass)) {
            throw new StorageException("Method sensor type class name cannot be null or empty!");
        }
        if (null == priority) {
            throw new StorageException("Method sensor type priority cannot be null!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        MethodSensorTypeConfig sensorTypeConfig = new MethodSensorTypeConfig();
        sensorTypeConfig.setName(sensorTypeName);
        sensorTypeConfig.setClassName(sensorTypeClass);
        sensorTypeConfig.setPriority(priority);
        sensorTypeConfig.setParameters(settings);
        this.methodSensorTypes.add(sensorTypeConfig);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Method sensor type added: " + sensorTypeName + " prio: " + (Object)((Object)priority));
        }
    }

    @Override
    public List<MethodSensorTypeConfig> getMethodSensorTypes() {
        return Collections.unmodifiableList(this.methodSensorTypes);
    }

    @Override
    public void addPlatformSensorType(String sensorTypeClass, Map<String, Object> settings) throws StorageException {
        if (null == sensorTypeClass || "".equals(sensorTypeClass)) {
            throw new StorageException("Platform sensor type class name cannot be null or empty!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        PlatformSensorTypeConfig sensorTypeConfig = new PlatformSensorTypeConfig();
        sensorTypeConfig.setClassName(sensorTypeClass);
        sensorTypeConfig.setParameters(settings);
        this.platformSensorTypes.add(sensorTypeConfig);
        if (this.log.isInfoEnabled()) {
            this.log.info("Platform sensor type added: " + sensorTypeClass);
        }
    }

    @Override
    public List<PlatformSensorTypeConfig> getPlatformSensorTypes() {
        return Collections.unmodifiableList(this.platformSensorTypes);
    }

    @Override
    public void addSensor(String sensorTypeName, String targetClassName, String targetMethodName, List<String> parameterList, boolean ignoreSignature, Map<String, Object> settings) throws StorageException {
        PropertyAccessor.PropertyPath path;
        PropertyAccessor.PropertyPath parentPath;
        String[] steps;
        PropertyAccessor.PropertyPathStart start;
        if (null == sensorTypeName || "".equals(sensorTypeName)) {
            throw new StorageException("Sensor type name for the sensor cannot be null or empty!");
        }
        if (null == targetClassName || "".equals(targetClassName)) {
            throw new StorageException("Target class name cannot be null or empty!");
        }
        if (null == targetMethodName || "".equals(targetMethodName)) {
            throw new StorageException("Target method name cannot be null or empty!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        UnregisteredSensorConfig sensorConfig = new UnregisteredSensorConfig(this.classPoolAnalyzer, this.inheritanceAnalyzer);
        sensorConfig.setTargetClassName(targetClassName);
        sensorConfig.setTargetMethodName(targetMethodName);
        if ("<init>".equals(targetMethodName)) {
            sensorConfig.setConstructor(true);
        }
        sensorConfig.setIgnoreSignature(ignoreSignature);
        sensorConfig.setParameterTypes(parameterList);
        sensorConfig.setSettings(settings);
        MethodSensorTypeConfig methodSensorTypeConfig = this.getMethodSensorTypeConfigForName(sensorTypeName);
        sensorConfig.setSensorTypeConfig(methodSensorTypeConfig);
        if (ignoreSignature) {
            sensorConfig.setVirtual(true);
        }
        if (settings.containsKey("superclass") && settings.get("superclass").equals("true")) {
            sensorConfig.setSuperclass(true);
        }
        if (settings.containsKey("interface") && settings.get("interface").equals("true")) {
            sensorConfig.setInterface(true);
        }
        if (settings.containsKey("annotation")) {
            sensorConfig.setAnnotationClassName((String)settings.get("annotation"));
        }
        if (settings.containsKey("modifiers")) {
            String modifiersString = (String)settings.get("modifiers");
            String separator = ",";
            StringTokenizer tokenizer = new StringTokenizer(modifiersString, separator);
            int modifiers = 0;
            while (tokenizer.hasMoreTokens()) {
                String modifier = tokenizer.nextToken().trim();
                if (modifier != null && modifier.startsWith("pub")) {
                    modifiers |= 1;
                    continue;
                }
                if (modifier != null && modifier.startsWith("priv")) {
                    modifiers |= 2;
                    continue;
                }
                if (modifier != null && modifier.startsWith("prot")) {
                    modifiers |= 4;
                    continue;
                }
                if (modifier == null || !modifier.startsWith("def")) continue;
                modifiers |= 0x8000;
            }
            sensorConfig.setModifiers(modifiers);
        }
        if (settings.containsKey("field")) {
            List fieldAccessorList = (List)settings.get("field");
            for (String fieldDefinition : fieldAccessorList) {
                String[] fieldDefinitionParts = fieldDefinition.split(";");
                String name = fieldDefinitionParts[0];
                start = new PropertyAccessor.PropertyPathStart();
                start.setName(name);
                start.setContentType(ParameterContentType.FIELD);
                steps = fieldDefinitionParts[1].split("\\.");
                parentPath = start;
                for (String step : steps) {
                    path = new PropertyAccessor.PropertyPath();
                    path.setName(step);
                    parentPath.setPathToContinue(path);
                    parentPath = path;
                }
                sensorConfig.getPropertyAccessorList().add(start);
            }
        }
        if (settings.containsKey("property")) {
            List propertyAccessorList = (List)settings.get("property");
            for (String fieldDefinition : propertyAccessorList) {
                String[] fieldDefinitionParts = fieldDefinition.split(";");
                int position = Integer.parseInt(fieldDefinitionParts[0]);
                String name = fieldDefinitionParts[1];
                PropertyAccessor.PropertyPathStart start2 = new PropertyAccessor.PropertyPathStart();
                start2.setName(name);
                start2.setContentType(ParameterContentType.PARAM);
                start2.setSignaturePosition(position);
                if (3 == fieldDefinitionParts.length) {
                    String[] steps2 = fieldDefinitionParts[2].split("\\.");
                    PropertyAccessor.PropertyPath parentPath2 = start2;
                    for (String step : steps2) {
                        PropertyAccessor.PropertyPath path2 = new PropertyAccessor.PropertyPath();
                        path2.setName(step);
                        parentPath2.setPathToContinue(path2);
                        parentPath2 = path2;
                    }
                }
                sensorConfig.getPropertyAccessorList().add(start2);
            }
        }
        if (settings.containsKey("return") && !sensorConfig.isConstructor()) {
            List returnAccessorList = (List)settings.get("return");
            for (String returnDefinition : returnAccessorList) {
                String[] returnDefinitionParts = returnDefinition.split(";");
                String name = returnDefinitionParts[0];
                start = new PropertyAccessor.PropertyPathStart();
                start.setName(name);
                start.setContentType(ParameterContentType.RETURN);
                if (returnDefinitionParts.length > 1) {
                    steps = returnDefinitionParts[1].split("\\.");
                    parentPath = start;
                    for (String step : steps) {
                        path = new PropertyAccessor.PropertyPath();
                        path.setName(step);
                        parentPath.setPathToContinue(path);
                        parentPath = path;
                    }
                }
                sensorConfig.getPropertyAccessorList().add(start);
            }
        }
        sensorConfig.setPropertyAccess(!sensorConfig.getPropertyAccessorList().isEmpty());
        sensorConfig.completeConfiguration();
        this.unregisteredSensorConfigs.add(sensorConfig);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sensor configuration added: " + sensorConfig.toString());
        }
        if (methodSensorTypeConfig.isJRebelActive()) {
            UnregisteredSensorConfig jRebelSensorConfig = JRebelUtil.getJRebelSensorConfiguration(sensorConfig, this.classPoolAnalyzer, this.inheritanceAnalyzer);
            jRebelSensorConfig.completeConfiguration();
            this.unregisteredSensorConfigs.add(jRebelSensorConfig);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sensor configuration for JRebel enhanced classes added: " + jRebelSensorConfig.toString());
            }
        }
    }

    private MethodSensorTypeConfig getMethodSensorTypeConfigForName(String sensorTypeName) throws StorageException {
        for (MethodSensorTypeConfig config : this.methodSensorTypes) {
            if (!config.getName().equals(sensorTypeName)) continue;
            return config;
        }
        throw new StorageException("Could not find method sensor type with name: " + sensorTypeName);
    }

    private MethodSensorTypeConfig getExceptionSensorTypeConfigForName(String sensorTypeName) throws StorageException {
        for (MethodSensorTypeConfig config : this.methodSensorTypes) {
            if (!config.getName().equals(sensorTypeName)) continue;
            return config;
        }
        throw new StorageException("Could not find exception sensor type with name: " + sensorTypeName);
    }

    @Override
    public List<UnregisteredSensorConfig> getUnregisteredSensorConfigs() {
        return Collections.unmodifiableList(this.unregisteredSensorConfigs);
    }

    @Override
    public List<MethodSensorTypeConfig> getExceptionSensorTypes() {
        ArrayList<MethodSensorTypeConfig> exceptionSensorTypes = new ArrayList<MethodSensorTypeConfig>();
        for (MethodSensorTypeConfig config : this.methodSensorTypes) {
            if (!config.getName().equals("info.novatec.inspectit.agent.sensor.exception.ExceptionSensor")) continue;
            exceptionSensorTypes.add(config);
        }
        return Collections.unmodifiableList(exceptionSensorTypes);
    }

    @Override
    public void addJmxSensorType(String sensorTypeClass, String sensorName) throws StorageException {
        if (StringUtils.isEmpty((String)sensorTypeClass)) {
            throw new StorageException("Jmx sensor type class name cannot be null or empty!");
        }
        JmxSensorTypeConfig sensorTypeConfig = new JmxSensorTypeConfig();
        sensorTypeConfig.setName(sensorName);
        sensorTypeConfig.setClassName(sensorTypeClass);
        this.jmxSensorTypes.add(sensorTypeConfig);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Jmx sensor type added: " + sensorTypeClass + "Name: " + sensorName);
        }
    }

    @Override
    public List<JmxSensorTypeConfig> getJmxSensorTypes() {
        return Collections.unmodifiableList(this.jmxSensorTypes);
    }

    private JmxSensorTypeConfig getJmxSensorTypeConfigForName(String jmxSensorTypeConfigname) throws StorageException {
        for (JmxSensorTypeConfig jmxSensorTypeConfig : this.jmxSensorTypes) {
            if (!jmxSensorTypeConfig.getName().equals(jmxSensorTypeConfigname)) continue;
            return jmxSensorTypeConfig;
        }
        return null;
    }

    @Override
    public void addUnregisteredJmxConfig(String jmxSensorTypeName, String mBeanName, String attributeName) throws StorageException {
        JmxSensorTypeConfig jstc = this.getJmxSensorTypeConfigForName(jmxSensorTypeName);
        UnregisteredJmxConfig ujc = new UnregisteredJmxConfig(jstc, mBeanName, attributeName);
        this.unregisteredJmxConfigs.add(ujc);
    }

    @Override
    public List<UnregisteredJmxConfig> getUnregisteredJmxConfigs() {
        return this.unregisteredJmxConfigs;
    }

    @Override
    public void addExceptionSensorType(String sensorTypeClass, Map<String, Object> settings) throws StorageException {
        if (null == sensorTypeClass || "".equals(sensorTypeClass)) {
            throw new StorageException("Exception sensor type class name cannot be null or empty!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        MethodSensorTypeConfig sensorTypeConfig = new MethodSensorTypeConfig();
        sensorTypeConfig.setName(sensorTypeClass);
        sensorTypeConfig.setClassName(sensorTypeClass);
        sensorTypeConfig.setParameters(settings);
        this.methodSensorTypes.add(sensorTypeConfig);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Exception sensor type added: " + sensorTypeClass);
        }
    }

    @Override
    public void addExceptionSensorTypeParameter(String sensorTypeName, String targetClassName, boolean isVirtual, Map<String, Object> settings) throws StorageException {
        if (null == sensorTypeName || "".equals(sensorTypeName)) {
            throw new StorageException("Sensor type name for the sensor cannot be null or empty!");
        }
        if (null == targetClassName || "".equals(targetClassName)) {
            throw new StorageException("Target class name cannot be null or empty!");
        }
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        UnregisteredSensorConfig sensorConfig = new UnregisteredSensorConfig(this.classPoolAnalyzer, this.inheritanceAnalyzer);
        sensorConfig.setVirtual(isVirtual);
        if (settings.containsKey("superclass") && settings.get("superclass").equals("true")) {
            sensorConfig.setSuperclass(true);
        }
        if (settings.containsKey("interface") && settings.get("interface").equals("true")) {
            sensorConfig.setInterface(true);
        }
        sensorConfig.setTargetClassName(targetClassName);
        sensorConfig.setSettings(settings);
        sensorConfig.setSensorTypeConfig(this.getExceptionSensorTypeConfigForName(sensorTypeName));
        sensorConfig.setTargetMethodName("");
        sensorConfig.setConstructor(true);
        sensorConfig.setExceptionSensorActivated(true);
        sensorConfig.setIgnoreSignature(true);
        sensorConfig.completeConfiguration();
        this.unregisteredSensorConfigs.add(sensorConfig);
        this.exceptionSensorActivated = true;
    }

    @Override
    public boolean isExceptionSensorActivated() {
        return this.exceptionSensorActivated;
    }

    @Override
    public void setEnhancedExceptionSensorActivated(boolean isEnhanced) {
        this.enhancedExceptionSensorActivated = isEnhanced;
        if (this.log.isDebugEnabled()) {
            if (isEnhanced) {
                this.log.debug("Using enhanced exception sensor mode");
            } else {
                this.log.debug("Using simple exception sensor mode");
            }
        }
    }

    @Override
    public boolean isEnhancedExceptionSensorActivated() {
        return this.enhancedExceptionSensorActivated;
    }

    @Override
    public List<IMatchPattern> getIgnoreClassesPatterns() {
        return this.ignoreClassesPatterns;
    }

    @Override
    public void addIgnoreClassesPattern(String patternString) {
        this.ignoreClassesPatterns.add(new SimpleMatchPattern(patternString));
    }

    @Override
    public Collection<IMatcher> getClassLoaderDelegationMatchers() {
        return this.classLoaderDelegationMatchers;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadConfigurationFromJvmParameters();
        this.createClassLoaderDelegationMatcher();
    }

    private void loadConfigurationFromJvmParameters() {
        String repositoryProperty = System.getProperty(REPOSITORY_PROPERTY);
        if (null == repositoryProperty) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(repositoryProperty, ";");
        if (tokenizer.countTokens() == 2) {
            String agentName;
            String[] repositoryIpHost = tokenizer.nextToken().split(":");
            if (repositoryIpHost.length == 2) {
                String repositoryIp = repositoryIpHost[0];
                String repositoryPort = repositoryIpHost[1];
                if (null != repositoryIp && !"".equals(repositoryIp) && null != repositoryPort && !"".equals(repositoryPort)) {
                    this.log.info("Repository information found in the JVM parameters: IP=" + repositoryIp + " Port=" + repositoryPort);
                    try {
                        int port = Integer.parseInt(repositoryPort);
                        this.setRepository(repositoryIp, port);
                    }
                    catch (Exception e) {
                        this.log.warn("Repository could not be defined from the data in the JVM parameters", (Throwable)e);
                    }
                }
            }
            if (null != (agentName = tokenizer.nextToken()) && !"".equals(agentName)) {
                try {
                    this.log.info("Agent name found in the JVM parameters: AgentName=" + agentName);
                    this.setAgentName(agentName);
                }
                catch (Exception e) {
                    this.log.warn("Agent name could not be defined from the data in the JVM parameters", (Throwable)e);
                }
            }
        }
    }

    private void createClassLoaderDelegationMatcher() {
        UnregisteredSensorConfig superclassSensorConfig = new UnregisteredSensorConfig(this.classPoolAnalyzer, this.inheritanceAnalyzer);
        superclassSensorConfig.setSuperclass(true);
        superclassSensorConfig.setTargetClassName("java.lang.ClassLoader");
        superclassSensorConfig.setTargetMethodName("loadClass");
        superclassSensorConfig.setParameterTypes(Collections.singletonList("java.lang.String"));
        superclassSensorConfig.setModifiers(1);
        UnregisteredSensorConfig directSensorConfig = new UnregisteredSensorConfig(this.classPoolAnalyzer, this.inheritanceAnalyzer);
        directSensorConfig.setTargetClassName("java.lang.ClassLoader");
        directSensorConfig.setTargetMethodName("loadClass");
        directSensorConfig.setParameterTypes(Collections.singletonList("java.lang.String"));
        directSensorConfig.setModifiers(1);
        SuperclassMatcher superclassIMatcher = new SuperclassMatcher(this.inheritanceAnalyzer, this.classPoolAnalyzer, superclassSensorConfig);
        DirectMatcher directIMatcher = new DirectMatcher(this.classPoolAnalyzer, superclassSensorConfig);
        this.classLoaderDelegationMatchers = Arrays.asList(superclassIMatcher, directIMatcher);
    }
}

