/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.buffer.impl;

import info.novatec.inspectit.agent.buffer.AbstractBufferStrategy;
import info.novatec.inspectit.agent.buffer.IBufferStrategy;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeBufferStrategy
extends AbstractBufferStrategy<MethodSensorData>
implements IBufferStrategy<MethodSensorData> {
    @Log
    Logger log;
    private static final int DEFAULT_COUNT = 60;
    private LinkedList<List<MethodSensorData>> stack;
    private int size;

    public SizeBufferStrategy() {
        this(60);
    }

    public SizeBufferStrategy(int size) {
        this.size = size;
        this.stack = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMeasurements(List<MethodSensorData> measurements) {
        if (null == measurements) {
            throw new IllegalArgumentException("Measurements cannot be null!");
        }
        SizeBufferStrategy sizeBufferStrategy = this;
        synchronized (sizeBufferStrategy) {
            if (this.stack.size() >= this.size) {
                this.stack.removeFirst();
                this.log.info("Possible data loss due to the excessive data creation on the Agent!");
            }
            this.stack.addLast(measurements);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MethodSensorData> next() {
        SizeBufferStrategy sizeBufferStrategy = this;
        synchronized (sizeBufferStrategy) {
            return this.stack.removeLast();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(Map<String, String> settings) {
        if (settings.containsKey("size")) {
            this.size = Integer.parseInt(settings.get("size"));
        }
    }
}

