/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.analyzer.impl.AbstractMatcher;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import java.util.ArrayList;
import java.util.List;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableMatcher
extends AbstractMatcher {
    private final IInheritanceAnalyzer inheritanceAnalyzer;
    private IMatcher delegateMatcher;

    public ThrowableMatcher(IInheritanceAnalyzer inheritanceAnalyzer, IClassPoolAnalyzer classPoolAnalyzer, UnregisteredSensorConfig unregisteredSensorConfig, IMatcher delegateMatcher) {
        super(classPoolAnalyzer, unregisteredSensorConfig);
        this.inheritanceAnalyzer = inheritanceAnalyzer;
        this.delegateMatcher = delegateMatcher;
    }

    @Override
    public boolean compareClassName(ClassLoader classLoader, String className) throws NotFoundException {
        return this.delegateMatcher.compareClassName(classLoader, className);
    }

    @Override
    public List<CtMethod> getMatchingMethods(ClassLoader classLoader, String className) throws NotFoundException {
        return this.delegateMatcher.getMatchingMethods(classLoader, className);
    }

    @Override
    public List<CtConstructor> getMatchingConstructors(ClassLoader classLoader, String className) throws NotFoundException {
        List<CtConstructor> matchingConstructors = this.delegateMatcher.getMatchingConstructors(classLoader, className);
        if (this.isThrowable(classLoader, className)) {
            CtConstructor[] constructors;
            if (matchingConstructors.isEmpty()) {
                matchingConstructors = new ArrayList<CtConstructor>();
            }
            CtClass clazz = this.classPoolAnalyzer.getClassPool(classLoader).get(className);
            for (CtConstructor constructor : constructors = clazz.getConstructors()) {
                if (matchingConstructors.contains(constructor)) continue;
                matchingConstructors.add(constructor);
            }
        }
        return matchingConstructors;
    }

    @Override
    public void checkParameters(List<? extends CtBehavior> methods) throws NotFoundException {
        this.delegateMatcher.checkParameters(methods);
    }

    private boolean isThrowable(ClassLoader classLoader, String className) {
        return this.inheritanceAnalyzer.subclassOf(className, "java.lang.Throwable", this.classPoolAnalyzer.getClassPool(classLoader));
    }
}

