/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IMatchPattern;
import java.util.ArrayList;

public class SimpleMatchPattern
implements IMatchPattern {
    private String[] components;
    private boolean isLeadText;
    private boolean isTrailText;
    private String template;
    private boolean everything = false;

    public SimpleMatchPattern(String template) {
        if ("*".equals(template)) {
            this.everything = true;
            this.isLeadText = false;
            this.isTrailText = false;
            return;
        }
        int mark = template.indexOf(42);
        ArrayList<String> comps = new ArrayList<String>();
        if (mark < 0) {
            comps.add(template);
            this.isLeadText = true;
            this.isTrailText = true;
        } else {
            int base = 0;
            if (mark == 0) {
                this.isLeadText = false;
                base = 1;
                mark = template.indexOf(42, 1);
            } else {
                this.isLeadText = true;
            }
            int limit = template.length() - 1;
            while (mark > 0) {
                comps.add(template.substring(base, mark));
                base = mark + 1;
                if (mark == limit) break;
                mark = template.indexOf(42, base);
            }
            comps.add(template.substring(base));
            this.isTrailText = mark != limit;
        }
        this.components = comps.toArray(new String[comps.size()]);
        this.template = template;
    }

    public final boolean match(String match) {
        if (this.everything) {
            return true;
        }
        int start = 0;
        int end = match.length();
        int index = 0;
        if (this.isLeadText) {
            if (match.startsWith(this.components[0])) {
                start = this.components[0].length();
                index = 1;
            } else {
                return false;
            }
        }
        int limit = this.components.length;
        if (this.isTrailText) {
            if (match.endsWith(this.components[--limit])) {
                end -= this.components[limit].length();
            } else {
                return false;
            }
        }
        while (index < limit) {
            String comp;
            if ((start = match.indexOf(comp = this.components[index++], start)) >= 0) {
                if ((start += comp.length()) <= end) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String getPattern() {
        return this.template;
    }

    public static boolean isPattern(String txt) {
        return txt.indexOf(42) > -1;
    }
}

