/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.analyzer.impl.AbstractMatcher;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import java.util.ArrayList;
import java.util.List;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierMatcher
extends AbstractMatcher {
    public static final int DEFAULT = 32768;
    private IMatcher delegateMatcher;

    public ModifierMatcher(IClassPoolAnalyzer classPoolAnalyzer, UnregisteredSensorConfig unregisteredSensorConfig, IMatcher delegateMatcher) {
        super(classPoolAnalyzer, unregisteredSensorConfig);
        this.delegateMatcher = delegateMatcher;
    }

    @Override
    public boolean compareClassName(ClassLoader classLoader, String className) throws NotFoundException {
        return this.delegateMatcher.compareClassName(classLoader, className);
    }

    @Override
    public List<CtMethod> getMatchingMethods(ClassLoader classLoader, String className) throws NotFoundException {
        List<CtMethod> matchingMethods = this.delegateMatcher.getMatchingMethods(classLoader, className);
        ArrayList<CtMethod> notMatchingMethods = null;
        for (CtMethod method : matchingMethods) {
            boolean modiferMatched = false;
            if (method.getModifiers() == this.unregisteredSensorConfig.getModifiers()) {
                modiferMatched = true;
            } else if (Modifier.isPublic((int)method.getModifiers()) && Modifier.isPublic((int)this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            } else if (Modifier.isProtected((int)method.getModifiers()) && Modifier.isProtected((int)this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            } else if (Modifier.isPrivate((int)method.getModifiers()) && Modifier.isPrivate((int)this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            } else if (Modifier.isPackage((int)method.getModifiers()) && ModifierMatcher.isDefault(this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            }
            if (modiferMatched) continue;
            if (null == notMatchingMethods) {
                notMatchingMethods = new ArrayList<CtMethod>();
            }
            notMatchingMethods.add(method);
        }
        if (null != notMatchingMethods) {
            try {
                matchingMethods.removeAll(notMatchingMethods);
            }
            catch (UnsupportedOperationException exception) {
                ArrayList<CtMethod> returnList = new ArrayList<CtMethod>();
                returnList.addAll(matchingMethods);
                returnList.removeAll(notMatchingMethods);
                return returnList;
            }
        }
        return matchingMethods;
    }

    @Override
    public List<CtConstructor> getMatchingConstructors(ClassLoader classLoader, String className) throws NotFoundException {
        List<CtConstructor> matchingConstructors = this.delegateMatcher.getMatchingConstructors(classLoader, className);
        ArrayList<CtConstructor> notMatchingConstructors = null;
        for (CtConstructor constructor : matchingConstructors) {
            boolean modiferMatched = false;
            if (constructor.getModifiers() == this.unregisteredSensorConfig.getModifiers()) {
                modiferMatched = true;
            } else if (Modifier.isPublic((int)constructor.getModifiers()) && Modifier.isPublic((int)this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            } else if (Modifier.isProtected((int)constructor.getModifiers()) && Modifier.isProtected((int)this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            } else if (Modifier.isPrivate((int)constructor.getModifiers()) && Modifier.isPrivate((int)this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            } else if (Modifier.isPackage((int)constructor.getModifiers()) && ModifierMatcher.isDefault(this.unregisteredSensorConfig.getModifiers())) {
                modiferMatched = true;
            }
            if (modiferMatched) continue;
            if (null == notMatchingConstructors) {
                notMatchingConstructors = new ArrayList<CtConstructor>();
            }
            notMatchingConstructors.add(constructor);
        }
        if (null != notMatchingConstructors) {
            try {
                matchingConstructors.removeAll(notMatchingConstructors);
            }
            catch (UnsupportedOperationException exception) {
                ArrayList<CtConstructor> returnList = new ArrayList<CtConstructor>();
                returnList.addAll(matchingConstructors);
                returnList.removeAll(notMatchingConstructors);
                return returnList;
            }
        }
        return matchingConstructors;
    }

    @Override
    public void checkParameters(List<? extends CtBehavior> methods) throws NotFoundException {
        this.delegateMatcher.checkParameters(methods);
    }

    public static boolean isDefault(int mod) {
        return (mod & 0x8000) != 0;
    }
}

