/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.analyzer.impl.AbstractMatcher;
import info.novatec.inspectit.agent.analyzer.impl.DirectMatcher;
import info.novatec.inspectit.agent.analyzer.impl.IndirectMatcher;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import java.util.Iterator;
import java.util.List;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceMatcher
extends AbstractMatcher {
    private final IInheritanceAnalyzer inheritanceAnalyzer;
    private IMatcher delegateMatcher;

    public InterfaceMatcher(IInheritanceAnalyzer inheritanceAnalyzer, IClassPoolAnalyzer classPoolAnalyzer, UnregisteredSensorConfig unregisteredSensorConfig) {
        super(classPoolAnalyzer, unregisteredSensorConfig);
        this.inheritanceAnalyzer = inheritanceAnalyzer;
        this.delegateMatcher = unregisteredSensorConfig.isVirtual() ? new IndirectMatcher(classPoolAnalyzer, unregisteredSensorConfig) : new DirectMatcher(classPoolAnalyzer, unregisteredSensorConfig);
    }

    @Override
    public boolean compareClassName(ClassLoader classLoader, String className) throws NotFoundException {
        Iterator<CtClass> i = this.inheritanceAnalyzer.getInterfaceIterator(classLoader, className);
        while (i.hasNext()) {
            CtClass clazz = i.next();
            if (!this.delegateMatcher.compareClassName(classLoader, clazz.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final List<CtMethod> getMatchingMethods(ClassLoader classLoader, String className) throws NotFoundException {
        return this.delegateMatcher.getMatchingMethods(classLoader, className);
    }

    @Override
    public List<CtConstructor> getMatchingConstructors(ClassLoader classLoader, String className) throws NotFoundException {
        return this.delegateMatcher.getMatchingConstructors(classLoader, className);
    }

    @Override
    public final void checkParameters(List<? extends CtBehavior> methods) throws NotFoundException {
        this.delegateMatcher.checkParameters(methods);
    }
}

