/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.spring.logger.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class InheritanceAnalyzer
implements IInheritanceAnalyzer {
    @Log
    Logger log;
    private Set<String> loggedClassesSet = new HashSet<String>();
    private final IClassPoolAnalyzer classPoolAnalyzer;

    @Autowired
    public InheritanceAnalyzer(IClassPoolAnalyzer classPoolAnalyzer) {
        this.classPoolAnalyzer = classPoolAnalyzer;
    }

    @Override
    public Iterator<CtClass> getSuperclassIterator(ClassLoader classLoader, String className) throws NotFoundException {
        ClassPool classPool = this.classPoolAnalyzer.getClassPool(classLoader);
        CtClass clazz = classPool.get(className);
        return new SuperclassIterator(clazz);
    }

    @Override
    public Iterator<CtClass> getInterfaceIterator(ClassLoader classLoader, String className) throws NotFoundException {
        ClassPool classPool = this.classPoolAnalyzer.getClassPool(classLoader);
        ArrayList<CtClass> interfaces = new ArrayList<CtClass>();
        for (CtClass ctClass = classPool.get(className); null != ctClass; ctClass = ctClass.getSuperclass()) {
            this.addInterfaceExtends(interfaces, ctClass);
        }
        return interfaces.iterator();
    }

    private void addInterfaceExtends(List<CtClass> interfaces, CtClass ctClass) throws NotFoundException {
        String[] ifs;
        block7: {
            ifs = null;
            try {
                ifs = ctClass.getClassFile2().getInterfaces();
            }
            catch (Exception e) {
                String className = ctClass.getName();
                if (!this.loggedClassesSet.add(className)) break block7;
                this.log.warn("Not possible to load interfaces for class " + className + ".");
            }
        }
        if (null != ifs) {
            int i;
            int num = ifs.length;
            CtClass[] ctClasses = new CtClass[num];
            for (i = 0; i < num; ++i) {
                try {
                    ctClasses[i] = ctClass.getClassPool().get(ifs[i]);
                    continue;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            for (i = 0; i < ctClasses.length; ++i) {
                if (null == ctClasses[i]) continue;
                CtClass interfaceCtClass = ctClasses[i];
                interfaces.add(interfaceCtClass);
                this.addInterfaceExtends(interfaces, interfaceCtClass);
            }
        }
    }

    @Override
    public boolean isInterface(String className, ClassLoader classLoader) throws NotFoundException {
        ClassPool classPool = this.classPoolAnalyzer.getClassPool(classLoader);
        CtClass actClass = classPool.get(className);
        return actClass.isInterface();
    }

    @Override
    public boolean implementsInterface(String className, ClassLoader classLoader, String interfaceName) {
        try {
            Iterator<CtClass> interfaceIterator = this.getInterfaceIterator(classLoader, className);
            while (interfaceIterator.hasNext()) {
                CtClass ctInterface = interfaceIterator.next();
                String name = ctInterface.getName();
                if (!name.equalsIgnoreCase(interfaceName)) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean subclassOf(String className, String superClassName, ClassPool classPool) {
        try {
            CtClass superClass = classPool.get(superClassName);
            CtClass clazz = classPool.get(className);
            if (clazz.subclassOf(superClass)) {
                return true;
            }
        }
        catch (NotFoundException e) {
            return false;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuperclassIterator
    implements Iterator<CtClass> {
        private CtClass superClass;

        public SuperclassIterator(CtClass clazz) throws NotFoundException {
            this.superClass = clazz;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.superClass.getSuperclass() != null;
            }
            catch (NotFoundException e) {
                return false;
            }
        }

        @Override
        public CtClass next() {
            try {
                this.superClass = this.superClass.getSuperclass();
            }
            catch (NotFoundException e) {
                throw new NoSuchElementException(e.getMessage());
            }
            if (null == this.superClass) {
                throw new NoSuchElementException();
            }
            return this.superClass;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

