/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatchPattern;
import info.novatec.inspectit.agent.analyzer.impl.AbstractMatcher;
import info.novatec.inspectit.agent.analyzer.impl.DirectMatcher;
import info.novatec.inspectit.agent.analyzer.impl.SimpleMatchPattern;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndirectMatcher
extends AbstractMatcher {
    private DirectMatcher directMatcher;
    private IMatchPattern classNamePattern = null;
    private IMatchPattern methodNamePattern = null;
    private Map<String, SimpleMatchPattern> parameterTypesPatterns = new HashMap<String, SimpleMatchPattern>();

    public IndirectMatcher(IClassPoolAnalyzer classPoolAnalyzer, UnregisteredSensorConfig unregisteredSensorConfig) {
        super(classPoolAnalyzer, unregisteredSensorConfig);
        this.directMatcher = new DirectMatcher(classPoolAnalyzer, unregisteredSensorConfig);
        if (SimpleMatchPattern.isPattern(unregisteredSensorConfig.getTargetClassName())) {
            this.classNamePattern = new SimpleMatchPattern(unregisteredSensorConfig.getTargetClassName());
        }
        if (SimpleMatchPattern.isPattern(unregisteredSensorConfig.getTargetMethodName())) {
            this.methodNamePattern = new SimpleMatchPattern(unregisteredSensorConfig.getTargetMethodName());
        }
        if (null != unregisteredSensorConfig.getParameterTypes()) {
            for (String parameter : unregisteredSensorConfig.getParameterTypes()) {
                if (!SimpleMatchPattern.isPattern(parameter)) continue;
                this.parameterTypesPatterns.put(parameter, new SimpleMatchPattern(parameter));
            }
        }
    }

    @Override
    public boolean compareClassName(ClassLoader classLoader, String className) throws NotFoundException {
        if (null == this.classNamePattern) {
            return this.directMatcher.compareClassName(classLoader, className);
        }
        return this.classNamePattern.match(className);
    }

    @Override
    public List<CtMethod> getMatchingMethods(ClassLoader classLoader, String className) throws NotFoundException {
        if (null == this.methodNamePattern) {
            return this.directMatcher.getMatchingMethods(classLoader, className);
        }
        CtMethod[] methods = this.classPoolAnalyzer.getMethodsForClassName(classLoader, className);
        if (null != methods && methods.length > 0) {
            ArrayList<CtMethod> matchingMethods = new ArrayList<CtMethod>();
            for (CtMethod method : methods) {
                if (Modifier.isAbstract((int)method.getModifiers()) || Modifier.isNative((int)method.getModifiers()) || !this.methodNamePattern.match(method.getName())) continue;
                matchingMethods.add(method);
            }
            return matchingMethods;
        }
        return Collections.emptyList();
    }

    @Override
    public List<CtConstructor> getMatchingConstructors(ClassLoader classLoader, String className) throws NotFoundException {
        if (null != this.methodNamePattern) {
            return Collections.emptyList();
        }
        return this.directMatcher.getMatchingConstructors(classLoader, className);
    }

    @Override
    public void checkParameters(List<? extends CtBehavior> methods) throws NotFoundException {
        if (!this.unregisteredSensorConfig.isIgnoreSignature()) {
            List<String> parameterTypes = this.unregisteredSensorConfig.getParameterTypes();
            if (this.parameterTypesPatterns.isEmpty()) {
                this.directMatcher.checkParameters(methods);
            } else if (null != parameterTypes) {
                Iterator<? extends CtBehavior> iterator = methods.iterator();
                while (iterator.hasNext()) {
                    CtBehavior behaviour = iterator.next();
                    CtClass[] ctClasses = behaviour.getParameterTypes();
                    if (parameterTypes.size() == ctClasses.length) {
                        for (int i = 0; i < parameterTypes.size(); ++i) {
                            if (this.parameterTypesPatterns.containsKey(parameterTypes.get(i))) {
                                if (((IMatchPattern)this.parameterTypesPatterns.get(parameterTypes.get(i))).match(ctClasses[i].getName())) continue;
                                iterator.remove();
                                continue;
                            }
                            if (parameterTypes.get(i).equals(ctClasses[i].getName())) continue;
                            iterator.remove();
                        }
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }
}

