/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.impl.AbstractMatcher;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMatcher
extends AbstractMatcher {
    public DirectMatcher(IClassPoolAnalyzer classPoolAnalyzer, UnregisteredSensorConfig unregisteredSensorConfig) {
        super(classPoolAnalyzer, unregisteredSensorConfig);
    }

    @Override
    public boolean compareClassName(ClassLoader classLoader, String className) throws NotFoundException {
        return this.unregisteredSensorConfig.getTargetClassName().equals(className);
    }

    @Override
    public List<CtMethod> getMatchingMethods(ClassLoader classLoader, String className) throws NotFoundException {
        CtMethod[] methods = this.classPoolAnalyzer.getMethodsForClassName(classLoader, className);
        if (methods.length > 0) {
            ArrayList<CtMethod> matchingMethods = new ArrayList<CtMethod>();
            for (CtMethod method : methods) {
                if (Modifier.isAbstract((int)method.getModifiers()) || Modifier.isNative((int)method.getModifiers()) || !method.getName().equals(this.unregisteredSensorConfig.getTargetMethodName())) continue;
                matchingMethods.add(method);
            }
            return matchingMethods;
        }
        return Collections.emptyList();
    }

    @Override
    public List<CtConstructor> getMatchingConstructors(ClassLoader classLoader, String className) throws NotFoundException {
        CtConstructor[] constructors = this.classPoolAnalyzer.getConstructorsForClassName(classLoader, className);
        if (constructors.length > 0 && "<init>".equals(this.unregisteredSensorConfig.getTargetMethodName())) {
            List<CtConstructor> constructorList = Arrays.asList(constructors);
            return new ArrayList<CtConstructor>(constructorList);
        }
        return Collections.emptyList();
    }

    @Override
    public void checkParameters(List<? extends CtBehavior> methods) throws NotFoundException {
        if (!this.unregisteredSensorConfig.isIgnoreSignature()) {
            List<String> parameterTypes = this.unregisteredSensorConfig.getParameterTypes();
            Iterator<? extends CtBehavior> iterator = methods.iterator();
            while (iterator.hasNext()) {
                CtBehavior behaviour = iterator.next();
                CtClass[] args = behaviour.getParameterTypes();
                if (null != parameterTypes && parameterTypes.size() == args.length) {
                    for (int i = 0; i < parameterTypes.size(); ++i) {
                        if (parameterTypes.get(i).equals(args[i].getName())) continue;
                        iterator.remove();
                        i = parameterTypes.size();
                    }
                    continue;
                }
                if (args.length < 0) continue;
                iterator.remove();
            }
        }
    }
}

