/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.util.WeakList;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ClassPoolAnalyzer
implements IClassPoolAnalyzer {
    @Log
    Logger log;
    private static WeakList<ClassLoader> classLoaders = new WeakList();
    private static Map<ClassLoader, ClassPool> map = new WeakHashMap<ClassLoader, ClassPool>();

    public CtMethod[] getMethodsForClassName(ClassLoader classLoader, String className) {
        try {
            CtClass cc = this.getClassPool(classLoader).get(className);
            if (!Modifier.isInterface((int)cc.getModifiers())) {
                return cc.getDeclaredMethods();
            }
        }
        catch (NotFoundException e) {
            this.log.error("NotFoundException caught for class: " + className);
        }
        catch (RuntimeException e) {
            this.log.error("Class which generated a runtime exception: " + className);
            this.log.error(e.getMessage());
        }
        return new CtMethod[0];
    }

    public CtConstructor[] getConstructorsForClassName(ClassLoader classLoader, String className) {
        try {
            CtClass cc = this.getClassPool(classLoader).get(className);
            ArrayList<CtConstructor> constructorList = new ArrayList<CtConstructor>();
            if (!Modifier.isInterface((int)cc.getModifiers())) {
                CtConstructor[] constructors = cc.getDeclaredConstructors();
                for (int i = 0; i < constructors.length; ++i) {
                    CtConstructor ctConstructor = constructors[i];
                    if (!ctConstructor.isConstructor()) continue;
                    constructorList.add(ctConstructor);
                }
                return constructorList.toArray(new CtConstructor[constructorList.size()]);
            }
        }
        catch (NotFoundException e) {
            this.log.error("NotFoundException caught for class: " + className);
        }
        catch (RuntimeException e) {
            this.log.error("Class which generated a runtime exception: " + className);
            this.log.error(e.getMessage());
        }
        return new CtConstructor[0];
    }

    public ClassPool addClassLoader(ClassLoader classLoader) {
        if (null == classLoader) {
            return ClassPool.getDefault();
        }
        if (!classLoaders.contains(classLoader)) {
            return this.copyHierarchy(classLoader);
        }
        return map.get(classLoader);
    }

    public ClassPool getClassPool(ClassLoader classLoader) {
        if (null == classLoader) {
            return ClassPool.getDefault();
        }
        ClassPool cp = map.get(classLoader);
        if (null == cp) {
            cp = this.addClassLoader(classLoader);
        }
        return cp;
    }

    private ClassPool copyHierarchy(ClassLoader classLoader) {
        if (!classLoaders.contains(classLoader)) {
            classLoaders.add(classLoader);
        }
        ClassPool cp = null;
        cp = null != classLoader.getParent() && !classLoaders.contains(classLoader.getParent()) ? new ClassPool(this.copyHierarchy(classLoader.getParent())) : (null != classLoader.getParent() ? new ClassPool(map.get(classLoader.getParent())) : new ClassPool(ClassPool.getDefault()));
        cp.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
        map.put(classLoader, cp);
        return cp;
    }
}

