/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IByteCodeAnalyzer;
import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.StorageException;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PropertyAccessor;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import info.novatec.inspectit.agent.hooking.IHookInstrumenter;
import info.novatec.inspectit.agent.hooking.impl.HookException;
import info.novatec.inspectit.communication.data.ParameterContentType;
import info.novatec.inspectit.spring.logger.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ByteCodeAnalyzer
implements IByteCodeAnalyzer {
    @Log
    Logger log;
    private final IHookInstrumenter hookInstrumenter;
    private final IConfigurationStorage configurationStorage;
    private final IClassPoolAnalyzer classPoolAnalyzer;
    @Value(value="${instrumentation.classLoaderDelegation}")
    boolean classLoaderDelegation;

    @Autowired
    public ByteCodeAnalyzer(IConfigurationStorage configurationStorage, IHookInstrumenter hookInstrumenter, IClassPoolAnalyzer classPoolAnalyzer) {
        if (null == configurationStorage) {
            throw new IllegalArgumentException("Configuration storage cannot be null!");
        }
        if (null == hookInstrumenter) {
            throw new IllegalArgumentException("Hook instrumenter cannot be null!");
        }
        if (null == classPoolAnalyzer) {
            throw new IllegalArgumentException("Class pool analyzer cannot be null!");
        }
        this.configurationStorage = configurationStorage;
        this.hookInstrumenter = hookInstrumenter;
        this.classPoolAnalyzer = classPoolAnalyzer;
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] analyzeAndInstrument(byte[] byteCode, String className, ClassLoader classLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<? extends CtBehavior> analyzeForClassLoaderDelegation(String className, ClassLoader classLoader) throws NotFoundException {
        if (!this.classLoaderDelegation) {
            return Collections.emptyList();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("analyzeForClassLoaderDelegation: " + className);
        }
        for (IMatcher matcher : this.configurationStorage.getClassLoaderDelegationMatchers()) {
            List<CtMethod> behaviors;
            if (null == matcher || !matcher.compareClassName(classLoader, className) || !CollectionUtils.isNotEmpty(behaviors = matcher.getMatchingMethods(classLoader, className))) continue;
            matcher.checkParameters(behaviors);
            return behaviors;
        }
        return Collections.emptyList();
    }

    private Map<CtBehavior, List<UnregisteredSensorConfig>> analyze(String className, ClassLoader classLoader) throws NotFoundException, StorageException {
        HashMap<CtBehavior, List<UnregisteredSensorConfig>> behaviorToConfigMap = new HashMap<CtBehavior, List<UnregisteredSensorConfig>>();
        for (UnregisteredSensorConfig unregisteredSensorConfig : this.configurationStorage.getUnregisteredSensorConfigs()) {
            IMatcher matcher = unregisteredSensorConfig.getMatcher();
            if (!matcher.compareClassName(classLoader, className)) continue;
            List<Object> behaviors = unregisteredSensorConfig.isConstructor() ? matcher.getMatchingConstructors(classLoader, className) : matcher.getMatchingMethods(classLoader, className);
            matcher.checkParameters(behaviors);
            for (CtBehavior ctBehavior : behaviors) {
                List<UnregisteredSensorConfig> configs;
                if (behaviorToConfigMap.containsKey(ctBehavior)) {
                    configs = (List)behaviorToConfigMap.get(ctBehavior);
                    configs.add(unregisteredSensorConfig);
                    continue;
                }
                configs = new ArrayList();
                configs.add(unregisteredSensorConfig);
                behaviorToConfigMap.put(ctBehavior, configs);
            }
        }
        return behaviorToConfigMap;
    }

    private CtBehavior instrumentSensors(Map<CtBehavior, List<UnregisteredSensorConfig>> methodToConfigMap) throws NotFoundException, HookException, IOException, CannotCompileException {
        CtBehavior ctBehavior = null;
        for (Map.Entry<CtBehavior, List<UnregisteredSensorConfig>> entry : methodToConfigMap.entrySet()) {
            ctBehavior = entry.getKey();
            List<UnregisteredSensorConfig> configs = entry.getValue();
            ArrayList<String> parameterTypes = new ArrayList<String>();
            CtClass[] parameterClasses = ctBehavior.getParameterTypes();
            for (int pos = 0; pos < parameterClasses.length; ++pos) {
                parameterTypes.add(parameterClasses[pos].getName());
            }
            RegisteredSensorConfig rsc = new RegisteredSensorConfig();
            rsc.setTargetPackageName(ctBehavior.getDeclaringClass().getPackageName());
            rsc.setTargetClassName(ctBehavior.getDeclaringClass().getSimpleName());
            rsc.setTargetMethodName(ctBehavior.getName());
            rsc.setParameterTypes(parameterTypes);
            rsc.setModifiers(ctBehavior.getModifiers());
            rsc.setCtBehavior(ctBehavior);
            rsc.setConstructor(ctBehavior instanceof CtConstructor);
            if (!rsc.isConstructor()) {
                CtMethod ctMethod = (CtMethod)ctBehavior;
                rsc.setReturnType(ctMethod.getReturnType().getName());
            }
            for (UnregisteredSensorConfig usc : configs) {
                rsc.addSensorTypeConfig(usc.getSensorTypeConfig());
                rsc.getSettings().putAll(usc.getSettings());
                if (!usc.isPropertyAccess()) continue;
                for (PropertyAccessor.PropertyPathStart propertyPathStart : usc.getPropertyAccessorList()) {
                    if (!this.isMeaningfulCapturing(propertyPathStart.getContentType(), rsc)) continue;
                    rsc.getPropertyAccessorList().add(propertyPathStart);
                }
            }
            rsc.setPropertyAccess(!rsc.getPropertyAccessorList().isEmpty());
            if (this.configurationStorage.isExceptionSensorActivated() && this.configurationStorage.isEnhancedExceptionSensorActivated()) {
                for (MethodSensorTypeConfig config : this.configurationStorage.getExceptionSensorTypes()) {
                    rsc.setExceptionSensorTypeConfig(config);
                }
            }
            if (!rsc.isConstructor()) {
                this.hookInstrumenter.addMethodHook((CtMethod)ctBehavior, rsc);
                continue;
            }
            this.hookInstrumenter.addConstructorHook((CtConstructor)ctBehavior, rsc);
        }
        return ctBehavior;
    }

    private CtBehavior instrumentClassLoader(List<? extends CtBehavior> classLoaderDelegationBehaviors) throws NotFoundException, HookException, IOException, CannotCompileException {
        CtBehavior ctBehavior = null;
        if (CollectionUtils.isNotEmpty(classLoaderDelegationBehaviors)) {
            Iterator<? extends CtBehavior> i$ = classLoaderDelegationBehaviors.iterator();
            while (i$.hasNext()) {
                CtBehavior clDelegationBehavior;
                ctBehavior = clDelegationBehavior = i$.next();
                this.hookInstrumenter.addClassLoaderDelegationHook((CtMethod)ctBehavior);
            }
        }
        return ctBehavior;
    }

    private boolean isMeaningfulCapturing(ParameterContentType type, RegisteredSensorConfig rsc) {
        if (ParameterContentType.RETURN.equals((Object)type) && rsc.isConstructor()) {
            return false;
        }
        return !ParameterContentType.RETURN.equals((Object)type) || rsc.isConstructor() || !"void".equals(rsc.getReturnType());
    }
}

