/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.analyzer.impl;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatcher;
import info.novatec.inspectit.agent.analyzer.impl.AbstractMatcher;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMatcher
extends AbstractMatcher {
    private IMatcher delegateMatcher;
    private IInheritanceAnalyzer inheritanceAnalyzer;

    public AnnotationMatcher(IInheritanceAnalyzer inheritanceAnalyzer, IClassPoolAnalyzer classPoolAnalyzer, UnregisteredSensorConfig unregisteredSensorConfig, IMatcher delegateMatcher) {
        super(classPoolAnalyzer, unregisteredSensorConfig);
        this.inheritanceAnalyzer = inheritanceAnalyzer;
        this.delegateMatcher = delegateMatcher;
    }

    @Override
    public boolean compareClassName(ClassLoader classLoader, String className) throws NotFoundException {
        return this.delegateMatcher.compareClassName(classLoader, className);
    }

    @Override
    public List<CtMethod> getMatchingMethods(ClassLoader classLoader, String className) throws NotFoundException {
        List<CtMethod> matchingMethods = this.delegateMatcher.getMatchingMethods(classLoader, className);
        boolean classHasAnnotation = this.checkClassForAnnotation(classLoader, className, this.unregisteredSensorConfig.getAnnotationClassName());
        if (!classHasAnnotation) {
            ArrayList<CtMethod> notMatchingMethods = null;
            for (CtMethod method : matchingMethods) {
                List methodAttributesList = method.getMethodInfo2().getAttributes();
                boolean methodHasAnnotation = this.checkForAnnotation(methodAttributesList, this.unregisteredSensorConfig.getAnnotationClassName());
                if (methodHasAnnotation) continue;
                if (null == notMatchingMethods) {
                    notMatchingMethods = new ArrayList<CtMethod>();
                }
                notMatchingMethods.add(method);
            }
            if (null != notMatchingMethods) {
                try {
                    matchingMethods.removeAll(notMatchingMethods);
                }
                catch (UnsupportedOperationException exception) {
                    ArrayList<CtMethod> returnList = new ArrayList<CtMethod>();
                    returnList.addAll(matchingMethods);
                    returnList.removeAll(notMatchingMethods);
                    return returnList;
                }
            }
        }
        return matchingMethods;
    }

    @Override
    public List<CtConstructor> getMatchingConstructors(ClassLoader classLoader, String className) throws NotFoundException {
        List<CtConstructor> matchingConstructors = this.delegateMatcher.getMatchingConstructors(classLoader, className);
        boolean classHasAnnotation = this.checkClassForAnnotation(classLoader, className, this.unregisteredSensorConfig.getAnnotationClassName());
        if (!classHasAnnotation) {
            ArrayList<CtConstructor> notMatchingConstructors = null;
            for (CtConstructor constructor : matchingConstructors) {
                List constructorAttributesList = constructor.getMethodInfo2().getAttributes();
                boolean constructorHasAnnotation = this.checkForAnnotation(constructorAttributesList, this.unregisteredSensorConfig.getAnnotationClassName());
                if (constructorHasAnnotation) continue;
                if (null == notMatchingConstructors) {
                    notMatchingConstructors = new ArrayList<CtConstructor>();
                }
                notMatchingConstructors.add(constructor);
            }
            if (null != notMatchingConstructors) {
                try {
                    matchingConstructors.removeAll(notMatchingConstructors);
                }
                catch (UnsupportedOperationException exception) {
                    ArrayList<CtConstructor> returnList = new ArrayList<CtConstructor>();
                    returnList.addAll(matchingConstructors);
                    returnList.removeAll(notMatchingConstructors);
                    return returnList;
                }
            }
        }
        return matchingConstructors;
    }

    private boolean checkClassForAnnotation(ClassLoader classLoader, String className, String annotationClassName) throws NotFoundException {
        Iterator<CtClass> iterator2;
        CtClass clazz = this.classPoolAnalyzer.getClassPool(classLoader).get(className);
        List classAttributesList = clazz.getClassFile2().getAttributes();
        if (this.checkForAnnotation(classAttributesList, annotationClassName)) {
            return true;
        }
        try {
            iterator2 = this.inheritanceAnalyzer.getSuperclassIterator(classLoader, className);
            while (iterator2.hasNext()) {
                List superClassAttributeList = iterator2.next().getClassFile2().getAttributes();
                if (!this.checkForAnnotation(superClassAttributeList, annotationClassName)) continue;
                return true;
            }
        }
        catch (NotFoundException iterator2) {
            // empty catch block
        }
        try {
            iterator2 = this.inheritanceAnalyzer.getInterfaceIterator(classLoader, className);
            while (iterator2.hasNext()) {
                List interfaceClassAttributeList = iterator2.next().getClassFile2().getAttributes();
                if (!this.checkForAnnotation(interfaceClassAttributeList, annotationClassName)) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkForAnnotation(List<AttributeInfo> attributesList, String annotationClassName) {
        for (int i = 0; i < attributesList.size(); ++i) {
            AttributeInfo attributeInfo = attributesList.get(i);
            if (!(attributeInfo instanceof AnnotationsAttribute)) continue;
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)attributeInfo;
            Annotation[] annotations = annotationsAttribute.getAnnotations();
            for (int j = 0; j < annotations.length; ++j) {
                if (!annotations[j].getTypeName().equals(annotationClassName)) continue;
                return true;
            }
            break;
        }
        return false;
    }

    @Override
    public void checkParameters(List<? extends CtBehavior> methods) throws NotFoundException {
        this.delegateMatcher.checkParameters(methods);
    }
}

