/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent;

import info.novatec.inspectit.agent.IAgent;
import info.novatec.inspectit.agent.analyzer.IByteCodeAnalyzer;
import info.novatec.inspectit.agent.analyzer.IMatchPattern;
import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.hooking.IHookDispatcher;
import info.novatec.inspectit.agent.logback.LogInitializer;
import info.novatec.inspectit.agent.spring.SpringConfiguration;
import info.novatec.inspectit.version.VersionService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringAgent
implements IAgent {
    private static final Logger LOG = LoggerFactory.getLogger(SpringAgent.class);
    private static final String CLASS_NAME_PREFIX = "info.novatec.inspectit";
    private IHookDispatcher hookDispatcher;
    private boolean initializationError = false;
    private BeanFactory beanFactory;

    public SpringAgent(String inspectitJarLocation) {
        LogInitializer.setInspectitJarLocation(inspectitJarLocation);
        LogInitializer.initLogging();
        this.initSpring();
    }

    private void initSpring() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initializing Spring on inspectIT Agent...");
        }
        ClassLoader inspectITClassLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(inspectITClassLoader);
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
        ctx.register(new Class[]{SpringConfiguration.class});
        ctx.refresh();
        this.beanFactory = ctx;
        if (LOG.isInfoEnabled()) {
            LOG.info("Spring successfully initialized");
        }
        if (LOG.isInfoEnabled()) {
            VersionService versionService = (VersionService)this.beanFactory.getBean(VersionService.class);
            LOG.info("Using agent version " + versionService.getVersionAsString() + ".");
        }
        this.hookDispatcher = (IHookDispatcher)this.beanFactory.getBean(IHookDispatcher.class);
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    @Override
    public byte[] inspectByteCode(byte[] byteCode, String className, ClassLoader classLoader) {
        if (this.initializationError) {
            return byteCode;
        }
        IConfigurationStorage configurationStorage = (IConfigurationStorage)this.beanFactory.getBean(IConfigurationStorage.class);
        List<IMatchPattern> ignoreClassesPatterns = configurationStorage.getIgnoreClassesPatterns();
        for (IMatchPattern matchPattern : ignoreClassesPatterns) {
            if (!matchPattern.match(className)) continue;
            return byteCode;
        }
        IByteCodeAnalyzer byteCodeAnalyzer = (IByteCodeAnalyzer)this.beanFactory.getBean(IByteCodeAnalyzer.class);
        try {
            byte[] instrumentedByteCode = byteCodeAnalyzer.analyzeAndInstrument(byteCode, className, classLoader);
            return instrumentedByteCode;
        }
        catch (Throwable throwable) {
            LOG.error("Something unexpected happened while trying to analyze or instrument the bytecode with the class name: " + className, throwable);
            return byteCode;
        }
    }

    @Override
    public Class<?> loadClass(Object[] params) {
        try {
            Object p;
            if (null != params && params.length == 1 && (p = params[0]) instanceof String) {
                return this.loadClass((String)p);
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Class<?> loadClass(String className) {
        if (this.loadWithInspectItClassLoader(className)) {
            try {
                return this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private boolean loadWithInspectItClassLoader(String className) {
        return className.startsWith(CLASS_NAME_PREFIX);
    }

    @Override
    public IHookDispatcher getHookDispatcher() {
        return this.hookDispatcher;
    }
}

